<?php

/*
    Copyright 2012-2020 OpenBroadcaster, Inc.

    This file is part of OpenBroadcaster Server.

    OpenBroadcaster Server is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenBroadcaster Server is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with OpenBroadcaster Server.  If not, see <http://www.gnu.org/licenses/>.
*/

require('components.php');

$load = OBFLoad::get_instance();

if(!empty($_COOKIE['ob_auth_id']) && !empty($_COOKIE['ob_auth_key']))
{
  $auth_id = $_COOKIE['ob_auth_id'];
  $auth_key = $_COOKIE['ob_auth_key'];

  $user = OBFUser::get_instance();
  $user->auth($auth_id,$auth_key);
}

$ui_model = $load->model('ui');
$strings = $ui_model->strings();
$language = $ui_model->get_user_language();

header('Content-type: text/javascript');

echo 'OB.UI.strings = '.json_encode($strings).';';

if(!empty($language['code'])) echo "\n$(document).ready(function() { $('html').attr('lang','".$language['code']."'); });";
